'' /////////////////////////////////////////////////////////////////////////////
'' Graphics Renderer for Defender Remake
'' (C) Steve Waddicor
'' //////////////////////////////////////////////////////////////////////////////

'lines 24 + 2 braces + 2 dividers + 192 playfield = 220 

OBJ
    g   : "sw_df_globals_006"
    
CON
    PLAYFIELD_FIRST_LINE        = g#DIVIDER+2
    SCREEN_WIDTH                = 176
    SCREEN_WIDTH_IN_FRAMES      = SCREEN_WIDTH/4
    HORIZONTAL_TILES            = 22 

VAR
    'long  cog
    long  renderer_ptr_block

PUB start(cog_num,renderer_ptr)

'' Start renderer - starts a cog
'' returns false if no cog available

    renderer_ptr_block := renderer_ptr
    coginit(cog_num,@entry,renderer_ptr)

DAT

'******************************
'* Assembly language renderer *
'******************************

                        org
'
'
' Entry
'
entry
                        rdlong  rend_cog_number,PAR
                        mov     current_line,rend_cog_number  'start rendering from the top
                        
do_frame                'Load parameters
                        mov     r0,PAR
                        movd    :load_dest,#renderer_params+1
                        mov     count,#g#PARAM_COUNT-1 + g#NUMBER_OF_SPRITES + g#NUMBER_OF_SPRITES + g#NUMBER_OF_LASER_SHOTS + g#NUMBER_OF_COLORS + g#NUMBER_OF_BULLETS
:load                   add     r0,#4
                        '       ___
:load_dest              rdlong  0-0,r0
                        '       ^^^ iterates through renderer_params array.
                        add     :load_dest,inc_dest
                        djnz    count,#:load

                        mov     x_tile,rend_side_scroll
                        and     x_tile,long_word_mask
                        mov     end_terrain_ptr,rend_terrain_ptr
                        add     end_terrain_ptr,terrain_width          
                        
do_line                 ' Draw a single scan line
                        mov     current_playfield_line,current_line
                        sub     current_playfield_line,#PLAYFIELD_FIRST_LINE

                        mov     cog_scanline_buffer,black
                        movd    scan_line_store1,#cog_scanline_buffer+1
                        mov     hub_map_ptr,rend_tile_map_ptr    'point to first tile (upper-leftmost)

                        ' Init tiles loop
                        mov     r0,current_line   'then move down to current line first tile     r0=tile_row
                        sub     r0,#g#DIVIDER+2   'Start below scanner
                        shr     r0,#3             '8 lines per tile
                        shl     r0,#5             '32 tiles per row
                        add     hub_map_ptr,r0

                        mov     r0,current_line  'line offset within tile      r0=tile_line
                        sub     r0,#g#DIVIDER+2   'Start below scanner
                        and     r0,#$07          '8 lines per tile
                        shl     r0,#2            '4 bytes per line
                        mov     tile_table,rend_sprite_table_ptr 'get a local copy of tiletable address
                        add     tile_table,r0    'offset it to read correct tile_line

                        mov     x,#HORIZONTAL_TILES               'set horizontal tiles

do_tile                 rdbyte  tile,hub_map_ptr        'read tile

                        ' Get tile pixels
                        shl     tile,#5                 '32 bytes per tile
                        add     tile,tile_table         'convert to pointer
                        rdlong  pixels1,tile            'Pixels 1 = $78563412          32 bits


                        mov     count2,#2
dest_pair_loop
                        mov     mix2,#0
                        mov     count,#2
dest_long_loop
                        rol     pixels1,#4              'Pixels 1 = $56341278
                        mov     pixels2,pixels1
                        and     pixels2,#$F
                        add     pixels2,#rend_palette_0
                        movs    load_color,pixels2
                        nop
load_color              mov     mix1,0-0
                        or      mix2,mix1
                        ror     mix2,#8

                        rol     pixels1,#4              'Pixels 1 = $85634127
                        mov     pixels2,pixels1
                        and     pixels2,#$F
                        add     pixels2,#rend_palette_0
                        movs    load_color2,pixels2
                        nop
load_color2              mov     mix1,0-0
                        or      mix2,mix1
                        'rol     pixels1,#12             'Pixels 1 = $34127 856
                        ror     mix2,#8
                        
                        djnz    count,#dest_long_loop

scan_line_store1        mov     0-0,mix2
                        add     scan_line_store1,inc_dest
                        djnz    count2,#dest_pair_loop
                        
                        add     hub_map_ptr,#1          'point to next tile
                        djnz    x,#do_tile   wc         'another tile?


                        ' We've finished rendering the tiles
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                                                                                            

{'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
                        'Draw Terrain
                        mov     terrain_ptr,rend_terrain_ptr
                        add     terrain_ptr,x_tile
                        cmp     terrain_ptr,end_terrain_ptr wz,wc
              if_e      mov     terrain_ptr,rend_terrain_ptr

                        rdlong  terrain,terrain_ptr
                        add     terrain_ptr,#4
                        cmp     terrain_ptr,end_terrain_ptr wz,wc
              if_e      mov     terrain_ptr,rend_terrain_ptr

                        mov     x_pixel,rend_side_scroll
                        and     x_pixel,#%0000_0011 wc,wz

:init_loop    if_ne     ror     terrain,#8
              if_ne     djnz    x_pixel,#:init_loop

                        mov     x_pixel,rend_side_scroll
                        shl     x_pixel,#30

                        movd    scan_line_store,#cog_scanline_buffer

                        mov     p,#SCREEN_WIDTH_IN_FRAMES
do_long
                        mov     mix2,black
                        cmp     rend_terrain_color,#$02 wz     'black
            if_e        jmp     #scan_line_store     
                        mov     count,#4
do_pixel
                        'get next pixel from terrain byte
                        mov     terrain_byte,terrain
                        and     terrain_byte,#$FF
                        cmp     current_playfield_line,terrain_byte wz

              if_e      and     mix2,top_three_bytes
              if_e      or      mix2,rend_terrain_color
                        ror     mix2,#8
                        ror     terrain,#8
                        
                        add     x_pixel,x_pixel_inc wc
              if_nc     jmp     #:not_terrain_boundary
                        rdlong  terrain,terrain_ptr
                        add     terrain_ptr,#4
                        cmp     terrain_ptr,end_terrain_ptr wz,wc
              if_e      mov     terrain_ptr,rend_terrain_ptr

:not_terrain_boundary
                        djnz    count,#do_pixel

scan_line_store         mov     0-0,mix2    'dest starts at cog_scanline_buffer
                        add     scan_line_store,inc_dest 'self-modify dest
 
                        djnz    p,#do_long

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
                        'Draw bullets
                        mov     this_sprite,#rend_bullets 'first sprites in array are drawn first

                        'get the sprite attibutes in sprite_attr which we'll use for the rest of the routine
bullet_loop             movs    :sprite_attr_load,this_sprite
                        nop
:sprite_attr_load       mov     r0,0-0 wc
                        'don't draw it if it has the invisible flag
              if_c      jmp     #:next_bullet

                        mov     sprite_x,r0                               'r0=sprite-y
                        ' reject of x is out of range.
                        shr     sprite_x,#6                                     ' r0 = xpos
 
                         ' find the y-span and reject if current-line isn't in it.
                        shr     r0,#22
                        cmp     r0,current_playfield_line wz,wc
              if_a      jmp     #:next_bullet
                        add     r0,#1
                        cmp     r0,current_playfield_line wz,wc
              if_b      jmp     #:next_bullet

                        sub     sprite_x,rend_side_scroll
                        and     sprite_x,world_width_mask
                        cmp     sprite_x,#0 wz,wc
              if_b      jmp     #:next_bullet
                        cmp     sprite_x,#175 wz,wc
              if_ae     jmp     #:next_bullet
:on_screen
                        'calculate start address in scan line buffer        
                        mov     r0,sprite_x
                        shr     r0,#2                   'r0 = xpos/4
                        and     r0,#%1111_1111
'                        test    r0,#%1000_0000 wz
'              if_nz     or      r0,sign_extend
                        add     r0,#cog_scanline_buffer
                        movd    :bullet_write_1,r0
                        
                        'calculate where the sprite stars within a frame
                        shr     sprite_x,#1 wc
            if_c        jmp     #:offset1or3
                        shr     sprite_x,#1 wc
            if_nc       movs    :bullet_write_1,#bullet0 ' it's offset 0               
            if_c        movs    :bullet_write_1,#bullet2 ' it's offset 2
                        jmp     #:bullet_write_1
:offset1or3
                        shr     sprite_x,#1 wc
            if_nc       movs    :bullet_write_1,#bullet1 ' it's offset 1               
            if_c        movs    :bullet_write_2,#bullet3b ' it's offset 3
            if_c        add     r0,#1
            if_c        movd    :bullet_write_2,r0
            if_c        movs    :bullet_write_1,#bullet3a ' it's offset 3
:bullet_write_2
            if_c        mov     0-0,0-0

:bullet_write_1         mov     0-0,0-0

:next_bullet            add     this_sprite,#1
                        cmp     this_sprite,#rend_bullets_end wz,wc
            if_ne       jmp     #bullet_loop             
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
                        movs    load_laser,#rend_lasers
                        mov     p,#g#NUMBER_OF_LASER_SHOTS
                        
load_laser              mov     tile_number,0-0
                        mov     draw_y,tile_number                                  
                        mov     sprite_x,tile_number 
                        and     draw_y,#$FF
                        cmp     draw_y,current_playfield_line wz,wc
              if_ne     jmp     #next_laser
                        shr     tile_number,#16                                          'laser number
                        shr     sprite_x,#10
                        and     sprite_x,#%111111
                        mov     r2,#cog_scanline_buffer
                        add     r2,sprite_x
                        mov     count,#4                                        '4 source longs

                        test    tile_number,#$100 wz
              if_nz     jmp     #face_left
              
                        shl     tile_number,#4                                           '16 bytes per laser
                        add     tile_number,rend_laser_def_ptr
                        movd    rol_dest1,r2
                        movd    and_dest1,r2
                        movd    or_dest1,r2

source_loop1            rdlong  r1,tile_number                                  'r1 = laser definition long
                        mov     count2,#8                                       'each source long defines 8 destination longs

dest_loop1              mov     count3,#4                                       'each destination long is 4 pixels                                                                '

pixel_loop1             rol     r1,#1 wc                                        'top bit copied to carry
and_dest1     if_c      and     0-0,top_three_bytes
or_dest1      if_c      or      0-0,rend_palette_1
rol_dest1               ror     0-0,#8
                        djnz    count3,#pixel_loop1

                        add     rol_dest1,inc_dest
                        add     and_dest1,inc_dest
                        add     or_dest1,inc_dest
'                        jmp     #laser_common
                        djnz    count2,#dest_loop1
                        
                        add     tile_number,#4
                        djnz    count,#source_loop1

                        jmp     #next_laser
'#######                
face_left
                        and     tile_number,#$FF
                        shl     tile_number,#4                                           '16 bytes per laser
                        add     tile_number,rend_laser_def_ptr
                        movd    rol_dest2,r2
                        movd    and_dest2,r2
                        movd    or_dest2,r2

source_loop2            rdlong  r1,tile_number                                  'r1 = laser definition long
                        mov     count2,#8                                       'each source long defines 8 destination longs

dest_loop2              mov     count3,#4                                       'each destination long is 4 pixels                                                                '

pixel_loop2             rol     r1,#1 wc                                        'top bit copied to carry
rol_dest2               rol     0-0,#8
and_dest2     if_c      and     0-0,top_three_bytes
or_dest2      if_c      or      0-0,rend_palette_1
                        djnz    count3,#pixel_loop2

                        sub     rol_dest2,inc_dest
                        sub     and_dest2,inc_dest
                        sub     or_dest2,inc_dest
laser_common            djnz    count2,#dest_loop2
                        
                        add     tile_number,#4
                        djnz    count,#source_loop2

next_laser              add     load_laser,#1                                  'next laser
                        djnz    p,#load_laser               '

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
}
                        ' Render sprites
sprites                 mov     this_sprite,#rend_sprites_loc 'first sprites in array are drawn first
                        mov     this_sprite_tile,#rend_sprites_tile 'first sprites in array are drawn first
sprite_loop
                        ' Verification: if the TV is already asking for this scanline or more
                        ' then panic, go to red alert with the debug LED and skip straight to TV output.
                        ' If the LED does light you need to consider optimising or allocating more
                        ' rendering cogs
                        call    #checktv
'        if_ae           mov     outa,#1
        if_ae           jmp     #start_tv_copy

                        'get the sprite attibutes in sprite_attr which we'll use for the rest of the routine
                        movs    :sprite_attr_load,this_sprite
                        nop
:sprite_attr_load       mov     sprite_attr,0-0 wc
                        'don't draw it if it has the invisible flag
              if_c      jmp     #next_sprite
                        
                        ' get the tile number and explode count
                        movs    :sprite_tile_load,this_sprite_tile
                        nop
:sprite_tile_load       mov     tile_number,0-0                                 ' ........_..EEEEEE_........_TTTTTTTT
                        mov     explode_count,tile_number
                        shr     explode_count,#16
                        and     tile_number,#$FF

                        ' reject of x is out of range.
                        mov     sprite_x,sprite_attr                            ' '%i.YYYYYY_YYyyyyyy_XXXXXXXX_XXxxxxxx (negative = invisible
                        shr     sprite_x,#6                                     ' r0 = xpos
                        sub     sprite_x,#4                                     ' centre the sprite
 
                         ' find the y-span and reject if current-line isn't in it.
                        mov     r0,sprite_attr wc                               'r0=sprite-y
                        shr     r0,#22
                        sub     r0,#4                                           ' centre the sprite

                        ' subtract explodecount*7 from x and explodecount*3 from y
                        add     r0,explode_count                                ' subtract explodecount*7 from x explodecount
                        add     sprite_x,explode_count                          
                        shl     explode_count,#2                                ' explodecount*8
                        sub     sprite_x,explode_count
                        sub     r0,explode_count 
                        shr     explode_count,#1                                ' explodecount*4

                        mov     draw_y,current_playfield_line
                        subs    draw_y,r0  wc,wz
              if_b      jmp     #next_sprite
                        mov     r1,#8                                           ' height of sprite in pixels
                        add     r1,explode_count                                ' explodecount*2
                        add     r1,explode_count                                ' explodecount*2
                        add     r1,explode_count                                ' explodecount*2
                        cmp     draw_y,r1 wc,wz
              if_ae     jmp     #next_sprite

                        and     sprite_x,world_width_mask
                        sub     sprite_x,rend_side_scroll
'                        cmp     sprite_x,#0 wz,wc
'              if_ae     jmp     #:on_screen
'                        cmp     sprite_x,#176 wz,wc
'              if_ae     jmp     #next_sprite
:on_screen
                        ' get the pixel data
                        shl     tile_number,#5          '32 bytes in a sprite
                        mov     hub_source,rend_sprite_table_ptr 'use hub_source for pixel data
                        add     hub_source,tile_number

                        ' add offset for y position in the tile
                        mov     r2,#0
                        mov     r3,#2
:adjust_draw_y_for_explode
                        cmp     draw_y,r2 wz,wc
              if_b      jmp     #next_sprite
                        cmp     draw_y,r3 wz,wc
              if_b      jmp     #:y_has_been_adjusted
                        sub     draw_y,explode_count wz,wc
              if_b      jmp     #next_sprite
                        add     r2,#2
                        add     r3,#2
                        jmp     #:adjust_draw_y_for_explode
                                      
:y_has_been_adjusted    shl     draw_y,#2                                       ' 4 bytes per sprite line
                        add     hub_source,draw_y

                        'calculate start address in scan line buffer        
                        mov     r0,sprite_x
                        shr     r0,#2                   'r0 = xpos/4
                        and     r0,#%1111_1111
                        test    r0,#%1000_0000 wz
              if_nz     or      r0,sign_extend
                        mov     cog_dest,#cog_scanline_buffer
                        adds    cog_dest,r0
                        
                        'calculate where the sprite stars within a frame
                        and     sprite_x,#%0000_0011

'***************************************************************************************************
                        'Code for converting 16 color sprites to hi-color

                         ' put pixel colours in own longs
                        rdlong  r1,hub_source           'pixels(r1) = $01234567
                        add     hub_source,#4           'after first long, do second long.

                        mov     count2,#4
:source_byte_loop
                        rol     r1,#8

                        'do a bounds check on scan line line buffer
                        cmp     cog_dest,#cog_scanline_buffer wz,wc
              if_b      jmp     #:common2
                        cmp     cog_dest,#end_of_cog_scanline_buffer wz,wc
              if_ae     jmp     #:common2
                        
                        mov     r2,r1
                        and     r2,#$FF wz              'first 2 pixels
              if_z      jmp     #:common2
              
                        mov     r3,r2                   

                        shr     r2,#4                   'r2 first pixel to display
                        add     r2,#rend_palette_0      'r2 is palette pointer
                        movs    :lookup_color_1,r2
                        
                        and     r3,#$F                  'r3 is second pixel to display
                        add     r3,#rend_palette_0
                        movs    :lookup_color_2,r3

:lookup_color_1         mov     r2,0-0
:lookup_color_2         mov     r3,0-0

                        cmp     sprite_x,#1 wz,wc
              if_e      jmp     #:offset1
                        cmp     sprite_x,#2 wz,wc
              if_e      jmp     #:offset2
                        cmp     sprite_x,#3 wz,wc
              if_e      jmp     #:offset3

:offset0
                        shl     r3,#8
                        movs    :maskit,#offset0mask
                        movd    :maskit,cog_dest
                        movd    :drawit,cog_dest
                        jmp     #:common

:offset1
                        shl     r3,#16
                        shl     r2,#8
                        movs    :maskit,#offset1mask
                        movd    :maskit,cog_dest
                        movd    :drawit,cog_dest
                        jmp     #:common
:offset2
'                        shl     r2,#8
                        shl     r3,#24
                        shl     r2,#16 
                        movs    :maskit,#offset2mask
                        movd    :maskit,cog_dest
                        movd    :drawit,cog_dest
:common
                        or      r2,r3
:maskit                 and     0-0,0-0
:drawit                 or      0-0,r2
                        jmp     #:common2
:offset3
                        shl     r2,#24
                        movd    :maskit1,cog_dest
                        movd    :drawit1,cog_dest
                        add     cog_dest,#1
                        movd    :maskit2,cog_dest
                        movd    :drawit2,cog_dest
                        sub     cog_dest,#1
                                          
:maskit1                and     0-0,offset3mask1
:maskit2                and     0-0,offset3mask2
:drawit1                or      0-0,r2
:drawit2                or      0-0,r3

:common2                'shr     r1,#8 
                        add     sprite_x,#2
                        add     sprite_x,explode_count
:adjust_x               cmp     sprite_x,#4 wz,wc
              if_ae     sub     sprite_x,#4
              if_ae     add     cog_dest,#1
              if_ae     jmp     #:adjust_x
              
                        djnz    count2,#:source_byte_loop

next_sprite             add     this_sprite,#1
                        add     this_sprite_tile,#1
                        cmp     this_sprite,#rend_sprites_end wz
              if_ne     jmp     #sprite_loop

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

                        ' We've finished rendering the line and we didn't have a hissy fit panic.
                        ' We need to wait here for the line we just prepared to be requested by the TV driver
wait_for_the_request
                        call    #checktv
              if_b      jmp     #wait_for_the_request

                        ' Our line has been requested so copy it to hub scan line buffer
start_tv_copy           movs    :nextcopy, #cog_scanline_buffer
                        mov     r0, rend_scanline_buffer
                        mov     count, #SCREEN_WIDTH_IN_FRAMES              ' length of visible scanline buffer in longs
:nextcopy               mov     r1,cog_scanline_buffer
                        add     :nextcopy, #1
                        wrlong  r1, r0
                        add     r0, #4
                        djnz    count, #:nextcopy

                        ' We've handed over the scanline to the TV driver, so do another.
allocate_next_job       add     current_line,rend_playfield_cog_count 'we only do every Nth line
                        ' Degrade gracefully when there's too much work to do.
                        call    #checktv
              if_ae     jmp     #allocate_next_job
                       ' Wrap around.
                        cmp     current_line,#g#SCANLINES wz,wc
              if_b      jmp     #do_line
                        sub     current_line,#g#SCANLINES - g#DIVIDER -2 
                        jmp     #do_frame


'-------------------------------------------------------------------
checktv                 ' Tf we're currently rendering a low numbered line when a high one is being requested
                        ' then that's OK because we wrapped around.



                        rdlong  scanline_req,rend_scanline_req_adr
                        cmp     scanline_req,#g#SCANLINES-8 wc,wz
              if_be     jmp     #:checkit
                        cmp     current_line,#g#DIVIDER+2+8 wc,wz
              if_be     cmp     scanline_req, current_line wz
                        'b = normal
                        'z = doit
                        'a = err
              if_be     jmp     #checktv_ret

:checkit                cmp     scanline_req, current_line wz, wc    'set carry if request is less than current.
                        'b = normal
                        'z = doit
                        'a = err

                        ' At this point, we could skip drawing sprites or something like that and go
                        ' straight to image output and still stay synced with the tv driver
                        ' We must be quick though!
                        'jmp #start_tv_copy
checktv_ret             ret
'-------------------------------------------------------------------

' Initialized data
inc_dest                long    1 << 9 << 0
black                   long    $02020202
'colorbar71              long    $0c_0c_0c_0c
'reverse                 long    $100_0000

' New for Defender
world_width_mask        long    %11_1111_1111
long_word_mask          long    $FFFF_FFFC
terrain_width           long    g#TERRAIN_WIDTH
x_pixel_inc             long    1<<30

offset0mask             long    $FFFF0000

offset1mask             long    $FF0000FF
offset2mask             long    $0000FFFF

sign_extend             'long    $FFFFFF00 same as next value
top_three_bytes         'long    $FFFFFF00 same as next value
offset3mask2            long    $FFFFFF00

offset3mask1            long    $00FFFFFF

constantFF00            long    $FF00
tile_palette_table      long    $00005252   '
                        long    $0000dd52
                        long    $00000552
                        long    $00003b52

                        long    $000052dd
                        long    $0000dddd
                        long    $000005dd
                        long    $00003bdd

                        long    $00005205
                        long    $0000dd05
                        long    $00000505
                        long    $00003b05

                        long    $0000523b
                        long    $0000dd3b
                        long    $0000053b
                        long    $00003b3b
inc_dest_2              long    2 << 9 << 0 
'Uninitiaised data - always keep it at the end of file to avoid nasty gotcha with RES.

' Parameter buffer
renderer_params
rend_cog_number         res     1
rend_playfield_cog_count res    1
rend_scanner_cog_count  res     1
rend_scanline_req_adr   res     1
rend_sprite_table_ptr   res     1
rend_character_table_ptr res    1   
rend_laser_def_ptr      res     1
rend_color_table_ptr    res     1
rend_tile_map_ptr       res     1              
rend_scanline_buffer    res     1
rend_terrain_ptr        res     1
rend_terrain_color      res     1
rend_side_scroll        res     1
rend_bcd_score          res     1                       'score in binary coded decimal
rend_sprites_loc        res     g#NUMBER_OF_SPRITES
rend_sprites_end                
rend_sprites_tile       res     g#NUMBER_OF_SPRITES
rend_lasers             res     g#NUMBER_OF_LASER_SHOTS
rend_bullets            res     g#NUMBER_OF_BULLETS
rend_bullets_end
rend_palette_0          res     1
rend_palette_1          res     1
rend_palette_2          res     1
rend_palette_3          res     1
rend_palette_4          res     1
rend_palette_5          res     1
rend_palette_6          res     1
rend_palette_7          res     1
rend_palette_8          res     1
rend_palette_9          res     1
rend_palette_10         res     1
rend_palette_11         res     1
rend_palette_12         res     1
rend_palette_13         res     1
rend_palette_14         res     1
rend_palette_15         res     1
' End of parameter buffer

' Cog scanline buffer = 292 pixels, 8 bits per pixel = 2336 bits = 292 bytes = 73 longs
'scratch1                res     1
cog_scanline_buffer     res     SCREEN_WIDTH_IN_FRAMES
end_of_cog_scanline_buffer
'scratch2                res     1
' End of scanline buffer

count                   res     1
count2                  res     1
count3                  res     1
current_line            res     1
current_playfield_line  res     1
draw_y                  res     1
sprite_x                res     1
sprite_attr             res     1
this_sprite             res     1
scanline_req            res     1
mix2                    res     1
r0                      res     1
r1                      res     1
r2                      res     1
r3                      res     1
tile_number             res     1
hub_source              res     1
cog_dest                res     1

'new for Defender
this_sprite_tile        res     1
terrain_ptr             res     1
end_terrain_ptr         res     1
terrain                 res     1
terrain_byte            res     1
p                       res     1
x_tile                  res     1
x_pixel                 res     1
explode_count           res     1

'new for tile renderer
hub_map_ptr             res     1
tile_table              res     1
x                       res     1
tile                    res     1
tile_palette            res     1
pixels1                 res     1
pixels2                 res     1
shifted4                res     1
shifted3                res     1
mix1                    res     1



              